; Dynamic 3rd Person Example

IncludeFile "X3D.pbi" 

hwnd.l=OpenWindow(1,50,50,640,480,#PB_Window_ScreenCentered,"Xtreme3D")

If hwnd=0 Or InitSprite()=0 Or InitKeyboard()=0 Or InitSound()=0
End
EndIf 

; Open smallest screen possible, just in order to make keyboard and mouse working
ws.l=OpenWindowedScreen(WindowID(1),0,0,1,1,0,0,0)

x3d_start_(0,0,640,480,hwnd,#FALSE) ; start 3D engine in windowed mode
x3d_sync_(#VSYNC) ; synchronize rendering with vertical refresh rate
x3d_lighting_(#FALSE); scene not affected by lights
x3d_setTexturePaths_("res") ; textures for level are in "res"
x3d_BackgroundColor_($000000) ; background color

; ********************** object sorting for correct rendering *****************
back.l=x3d_createObject_(#DUMMY,#NULL,"") ; place skydome, skybox,... inside
d3dobj.l=x3d_createObject_(#DUMMY,#NULL,"") ; for other objects
front.l=x3d_createObject_(#DUMMY,#NULL,""); for hud objects(text, 2D sprites)

down.l=x3d_createObject_(#DUMMY,#NULL,"") ; dummycube for raycasting
x3d_setAbsoluteObjectDirection_(down,0.0,-1.0,0.0) ; pointing down

; *************************** Camera **************************
radius.f=3.0
d.l=x3d_createObject_(#DUMMY,d3dobj,"")
x3d_setObjectPosition_(d,0.0,10.0,-50.0)
X3D_setFPSBSRadius_(d,radius) ; dummycube reacts to collisions

cam.l=x3d_createObject_(#CAMERA,d3dobj,"") 
x3d_setCameraViewDepth_(cam,800.0)
x3d_setCameraFocal_(cam,80.0)
x3d_SetCamera_(cam); activate camera
; camera must react to collisions, too, otherwise you could see through polygons
X3D_setFPSBSRadius_(cam,radius) 
x3d_setPositionOfObject_(cam,d)


; *************************** actor ***************************
actor.l=x3d_createObject_(#ACTOR, d, "res\penguin.md2")
x3d_createMaterial_("mpengu","res\tpenguin.jpg",#FALSE)
x3d_setMaterial_(actor, "mpengu")
x3d_setObjectScale_(actor,0.05,0.05,0.05)
x3d_setObjectPosition_(actor,0.0,-2.8,0.0)

; ************************** Level ****************************
 level.l=X3D_createObject_(#FREEFORM,d3dobj, "res\level.3ds")
 x3d_FPSAddMap_(level) ; level is tested for collisions

; ++++++++++++++++++++++++ water ++++++++++++++++++++++++++++++++
water.l=X3D_createObject_(#WATER,d3dobj,"")
 x3d_createMaterial_("mwater","res\water03.png",#FALSE)
 x3d_setTextureMappingMode_("mwater",#tmmCubeMapNormal)
 ;x3d_setBlendingMode_("mwater",#bmModulate)
 x3d_setMaterial_(water,"mwater")
 x3d_setObjectScale_(water,36.0,2.0,54.0)
 x3d_setObjectPosition_(water,0.0,-2.5,0.0)
 x3d_setWaterResolution_(water,8) ; small resolution=fast, high=slow but (much) better looking


target.l=x3d_createObject_(#DUMMY,d,"")
x3d_setObjectPosition_(target,0.0,10.0,-30.0)
x3d_setCameraTarget_(cam,d)

x3d_FogDistance_(10.0,600.0)
x3d_EnableFog_(#TRUE)

; ************************** font+text *****************************
bfont.l=x3d_createFont_("Arial",14)
txt.l=x3d_createObject_(#TEXT,#NULL,"Press B to turn MotionBlur on/off!")
x3d_SetTextFont_(txt, bfont)

jump.f=0
gravity.f=0
bblur=#FALSE

Repeat
 EventID.l = WindowEvent()
  ExamineKeyboard();

  
If KeyboardPushed(#PB_Key_Escape) 
   Quit = 1
 EndIf      
 
If KeyboardPushed(#PB_KEY_LEFT) 
    x3d_rotateObject_(d,0.0,3.0,0.0)
EndIf
If KeyboardPushed(#PB_KEY_RIGHT) 
    x3d_rotateObject_(d,0.0,-3.0,0.0)
EndIf
If KeyboardPushed(#PB_KEY_UP) 
    x3d_moveObject_(d,0.8)
EndIf
If KeyboardPushed(#PB_KEY_DOWN) 
    x3d_moveObject_(d,-0.8)
EndIf
If KeyboardPushed(#PB_KEY_A) 
    x3d_strafeObject_(d,-0.5)
EndIf
If KeyboardPushed(#PB_KEY_D) 
    x3d_strafeObject_(d,0.5)
EndIf
If KeyboardReleased(#PB_KEY_B) 
 If bblur
 x3d_deleteObject_(blur):bblur=#FALSE
 Else
 blur.l=x3d_createObject_(#BLUR,#NULL,"")
 x3d_setBlurPreset_(blur,#pOverBlur)
 bblur=#TRUE
  EndIf
EndIf


Gosub updateCam

If KeyboardPushed(#PB_KEY_SPACE) And ty.f<=dy.f
    jump.f=2.6
EndIf

fps=x3d_render_()
SetWindowTitle(1,"FPS: "+Str(fps))

  Until Quit = 1

x3d_end_(); close 3D scene 
End 

updateCam:
*v.vector=x3d_AbsoluteObjectPosition_(cam)
cx.f=*v\x
cy.f=*v\y
cz.f=*v\z

*v.vector=x3d_AbsoluteObjectPosition_(target)
tx.f=*v\x
ty.f=*v\y
tz.f=*v\z

dx.f=tx-cx : dy.f=ty-cy : dz.f=tz-cz
x3d_translateObject_(cam,dx*0.05, dy*0.05, dz*0.05)

x3d_liftObject_(d,-gravity+jump) ; do gravity and jumping 
jump-0.1
If jump<0:jump=0:EndIf

If PeekF(x3d_objectdistance_(cam, target))>30 ; in case we are stuck
x3d_liftObject_(cam,1.0)
EndIf

; are we falling/jumping?
x3d_setPositionOfObject_(down,d)
  *vb.vectorb=x3d_OctreeRaycast_(down,level)
 dy.f=*vb\y
 *v.vector=x3d_absoluteObjectPosition_(d)
 ty.f=*v\y-2.6

If ty>dy ; if we are not on the ground then increase gravity
 gravity+0.1
 Else:gravity=0.0
 EndIf


Return


; ExecutableFormat=Windows
; Executable=D:\temp\Xtreme3D\Purebasic\fire.exe
; CPU=1
; DisableDebugger
; EOF